*************************************************************************
BY: Jim Sullivan

CHAGNE: 6/17/2004: imported new vehicle smoothing data: predveh_sm
which fixed the problem with no vehicle data for 2000:5.

CHAGNE: 12/12/2005: commented out "IF 6 LE fam_type LE 8" & 
"IF sex_ref=2" and ran it for all sm's, swnk's, and mm's 

CHAGNE: 3/15/2008: ADDED 2005 DATA, AND COMBINED 2004:5 WITH 2005:1

CHAGNE: 8/18/2009: ADDED 2006 & 2007 DATA

CHAGNE: 12/18/2009: ADDED 2008 DATA

CHAGNE: 10/18/2010: ADDED 2009 DATA, REPLACED ALL 2005 & 2005 DATA B/C NOTICED
		    THAT SOME MEANS WERE DIFFERENT IN JULIETA'S ANALYSIS USING
		    NEWER DOWNLOAD FROM ICPSR, I.E. OWNDEPCQ, ETC. IT LOOKS LIKE
		    THIS AFFECTED 104:4 AND 104:5 ONLY

CHAGNE: 11/18/2011: ADDED 2010 DATA

NOTE: first run this, then run mkconsdat*
*************************************************************************
;

*%INCLUDE "~/jim/gzipseq.mcr"; 
LIBNAME mydat '~/jim/data';
LIBNAME ce05plus '~/jim/data/ce2005_present';
LIBNAME alldat '~/jim/data';

%include "~/jim/poverty/include/infile_cons.mcr";

*******  FAMILY FILES   **********;

filename fmly011 pipe 'gunzip -c ~/jim/data/03674-0001-Data.txt.gz';
filename fmly012 pipe 'gunzip -c ~/jim/data/03674-0005-Data.txt.gz';
filename fmly013 pipe 'gunzip -c ~/jim/data/03674-0009-Data.txt.gz';
filename fmly014 pipe 'gunzip -c ~/jim/data/03674-0013-Data.txt.gz';

filename fmly021 pipe 'gunzip -c ~/jim/data/03949-0001-Data.txt.gz';
filename fmly022 pipe 'gunzip -c ~/jim/data/03949-0005-Data.txt.gz';
filename fmly023 pipe 'gunzip -c ~/jim/data/03949-0009-Data.txt.gz';
filename fmly024 pipe 'gunzip -c ~/jim/data/03949-0013-Data.txt.gz';

filename fmly031 pipe 'gunzip -c ~/jim/data/fmlyi031x.txt.gz';
filename fmly032 pipe 'gunzip -c ~/jim/data/fmlyi032.txt.gz';
filename fmly033 pipe 'gunzip -c ~/jim/data/fmlyi033.txt.gz';
filename fmly034 pipe 'gunzip -c ~/jim/data/fmlyi034.txt.gz';

filename fmly041 pipe 'gunzip -c ~/jim/data/fmlyi041x.txt.gz';
filename fmly042 pipe 'gunzip -c ~/jim/data/fmlyi042.txt.gz';
filename fmly043 pipe 'gunzip -c ~/jim/data/fmlyi043.txt.gz';
filename fmly044 pipe 'gunzip -c ~/jim/data/fmlyi044.txt.gz';
filename fmly045 pipe 'gunzip -c ~/jim/data/fmlyi051.txt.gz';

*options obs=1000;

* reading the data;

***************  01:1  *************************************************;

DATA famly011;  
INFILE fmly011 lrecl=5800;
INPUT &dem9800 &con00; 

qyear=1011;

RUN;

***************  01:2  *************************************************;

DATA famly012;  
INFILE fmly012 lrecl=5800;
INPUT &dem0102 &con00; 

qyear=1012;

RUN;

***************  01:3  *************************************************;

DATA famly013;  
INFILE fmly013 lrecl=5800;
INPUT &dem0102 &con00; 

qyear=1013;

RUN;

***************  01:4  *************************************************;

DATA famly014;  
INFILE fmly014 lrecl=5800;
INPUT &dem0102 &con00; 

qyear=1014;

RUN;


***************  02:1  *************************************************;

DATA famly021;  
INFILE fmly021 lrecl=5800;
INPUT &dem0102 &con00; 

qyear=1021;

RUN;

***************  02:2  *************************************************;

DATA famly022;  
INFILE fmly022 lrecl=5800;
INPUT &dem0102 &con00; 

qyear=1022;

RUN;

***************  02:3  *************************************************;

DATA famly023;  
INFILE fmly023 lrecl=5800;
INPUT &dem0102 &con00; 

qyear=1023;

RUN;

***************  02:4  *************************************************;

DATA famly024;  
INFILE fmly024 lrecl=5800;
INPUT &dem0102 &con00; 

qyear=1024;

RUN;


***************  03:1  *************************************************;

DATA famly031;  
INFILE fmly031 lrecl=5800;
INPUT &dem0102 &con00; 

qyear=1031;

RUN;

***************  03:2  *************************************************;

DATA famly032;  
INFILE fmly032 lrecl=5800;
INPUT &dem0103 &con00; 

qyear=1032;

RUN;

***************  03:3  *************************************************;

DATA famly033;  
INFILE fmly033 lrecl=5800;
INPUT &dem0103 &con00; 

qyear=1033;

RUN;

***************  03:4  *************************************************;

DATA famly034;  
INFILE fmly034 lrecl=5800;
INPUT &dem0103 &con00; 

qyear=1034;

RUN;


***************  04:1  *************************************************;

DATA famly041;  
INFILE fmly041 lrecl=6300;
INPUT &dem04 &con04; 

qyear=1041;

RUN;

***************  04:2  *************************************************;

DATA famly042;  
INFILE fmly042 lrecl=6300;
INPUT &dem04 &con04; 

qyear=1042;

RUN;

***************  04:3  *************************************************;

DATA famly043;  
INFILE fmly043 lrecl=6300;
INPUT &dem04 &con04; 

qyear=1043;

RUN;

***************  04:4  *************************************************;

DATA famly044;  
INFILE fmly044 lrecl=6300;
INPUT &dem04 &con04; 

qyear=1044;

RUN;

***************  04:5  *************************************************;

DATA famly045;  
INFILE fmly045 lrecl=6300;
INPUT &dem04 &con04 ;

qyear=1045;

RUN;


******************************************************************************************
MACRO FOR 2005-2010 CEX DATA
******************************************************************************************;
******************************************************************************************
This macro reads in data for 05-10 from SAS datasets provided by CE Survye.  It keeps 
and renames variables of interest for all quarters for the years 2005-2010.  
Each quarter is given the name famly&qr (i.e. for quarter 2 of 2006 the dataset is called famly062).
For the original SAS datasets, quarters with an "X" on the end of their title refer to the 1st quarter 
of a year not the 5th quarter.  For example famly061 refers to quarter 5 of 2005 
while famly061x refers to quarter 1 of 2006

  STARTING WITH 2005 CE DATA, START WITH SAS DATASETS PROVIDED BY ICPSR
  RENAME SOME VARIABLES TO BE CONSISTENT WITH WHAT WE CALLED THEM IN 
  PREVIOUS YEARS
******************************************************************************************;
%MACRO read(qr_b,qr);
DATA famly&qr;
  SET ce05plus.fmli&qr_b (KEEP=
    age2 age_ref alcbevcq alcbevpq apparcq apparpq as_comp1 as_comp2 as_comp3 as_comp4 as_comp5
    bbydaycq bbydaypq bls_urbn cartkncq cartknpq cartkucq cartkupq cashcocq cashcopq childage cutenure
    domsrvcq domsrvpq educ_ref educa2 educacq educapq entertcq entertpq fam_size fam_type fdawaycq
    fdawaypq fdhomecq fdhomepq fdxmapcq fdxmappq flrcvrcq flrcvrpq foodcq foodpq foodsmpm furntrcq
    furntrpq gasmocq gasmopq govtcost healthcq healthpq houscq housopcq housoppq houspq inc_hrs1 
    inc_hrs2 incnonw1 incnonw2 incweek1 incweek2 majappcq majapppq marital1 misccq miscpq mrpinscq
    mrpinspq newid no_earnr nonincmx othaplcq othaplpq othlodcq othlodpq owndwecq owndwepq perscacq
    perscapq perslt18 persot64 publhous pubtracq pubtrapq race2 readcq readpq ref_race region rendwecq
    rendwepq respstat retpencq retpenpq rntapycq rntapypq sex_ref sheltcq sheltpq smsastat state telephcq
    telephpq tobacccq tobaccpq totexpcq totexppq transcq transpq utilcq utilpq vehfincq vehfinpq vehq

    QINTRVYR FINLWT21 RENTEQVX ROOMSQ WINDOWAC CNTRALAC BEDROOMQ BATHRMQ HLFBATHQ POVLEVCY FINCBTXM
    FJSSDEDM  FINCATXM HORREF1 FSALARYM FNONFRMM FFRMINCM FRRETIRM UNEMPLXM INTEARNM FININCXM PENSIONM
    HOUSEQPQ HOUSEQCQ OTHVEHPQ OTHVEHCQ ERNKMTHM QINTRVMO EARNCOMP RENT_QVX INCW_EK1 ckbkactx secestx
    usbndx savacctx CKBK_CTX secestx_ usbndx_ SAVA_CTX compbnd compbndx compckg compckgx compsav compsavx
    compsec compsecx comp_ndx comp_kgx comp_avx comp_ecx building

    fdmappq fdmapcq vothrlop vothrloc utilownp utilownc utilrntp utilrntc emrtpnop emrtpnoc

    WELFAREM FSSIXM OTHRINCM WTREP01-WTREP44

    RENAME=(FINLWT21=finlwt QINTRVYR=intvyr RENTEQVX=renteq ROOMSQ=rooms WINDOWAC=win_ac CNTRALAC=cen_ac
            BEDROOMQ=bedroom BATHRMQ=bathrm HLFBATHQ=hlfbath POVLEVCY=pov_cut FINCBTXM=fincbtax FJSSDEDM=fica
	    FINCATXM=fincatax HORREF1=origin2 FSALARYM=fsalaryx FNONFRMM=fnonfrmx FFRMINCM=ffrmincx 
	    FRRETIRM=frretirx UNEMPLXM=unemplx INTEARNM=intearnx FININCXM=finincx PENSIONM=pensionx
	    HOUSEQPQ=hfurnpq HOUSEQCQ=hfurncq OTHVEHPQ=caropq OTHVEHCQ=carocq ERNKMTHM=erankmth 
	    QINTRVMO=intvmo RENT_QVX=flg_rnt INCW_EK1=flg_wks CKBK_CTX=ckbkactx_ SAVA_CTX=savacctx_
	    WELFAREM=welfarex FSSIXM=fssix OTHRINCM=othrincx));
RUN;

DATA famly&qr;
  SET famly&qr(RENAME=(cen_ac=temp1 CHILDAGE=temp2 EDUC_REF=temp3 GOVTCOST=temp4 intvyr=temp5 origin2=temp6
                        PUBLHOUS=temp7 RESPSTAT=temp8 win_ac=temp9 compbnd=temp10 compckg=temp11 compsav=temp12 
			compsec=temp13 building=temp14 earncomp=temp15));

*Convert Character to Numeric;
cen_ac=temp1*1;
childage=temp2*1;
educ_ref=temp3*1;
govtcost=temp4*1;
intvyr=temp5*1;
origin2=temp6*1;
publhous=temp7*1;
respstat=temp8*1;
win_ac=temp9*1;
compbnd=temp10*1;
compckg=temp11*1;
compsav=temp12*1;
compsec=temp13*1;
building=temp14*1;
earncomp=temp15*1;

DROP temp1-temp15;

qyear=1&qr;

*THERE ARE NO INTERVIEWS IN JAN. FOR 051 FILE (VERIFIED THIS FROM INTVMO), SO INFLATE WGT BY 3/2; 
IF qyear=1051 THEN finlwt=finlwt*3/2; 

RUN;

%MEND read;

%read(051x,051);
%read(052,052);
%read(053,053);
%read(054,054);
%read(061x,061);
%read(062,062);
%read(063,063);
%read(064,064);
%read(071x,071);
%read(072,072);
%read(073,073);
%read(074,074);
%read(081x,081);
%read(082,082);
%read(083,083);
%read(084,084);
%read(091x,091);
%read(092,092);
%read(093,093);
%read(094,094);
%read(101x,101);
%read(102,102);
%read(103,103);
%read(104,104);
%read(111,105);

 
************************************************************************
MERGE 04:5 AND 05:1
BECAUSE THE CE SHIFTED TO 2000 WEIGHTS IN 2005, THESE 2 DATASETS ARE NOT
THE SAME OBS, ALTHOUGH THERE IS SOME OVERLAP.  WE USE OBS FROM BOTH 
DATASETS AND THEN ADJUST THE WEIGHTS ACCORDINGLY
************************************************************************;
DATA famly051; 
   MERGE famly045(in=in04 RENAME=(finlwt=wgt045)) 
	 famly051(in=in05 RENAME=(finlwt=FINLWT21));
   BY newid; 
 
IF in04 and in05 THEN dset=1;
ELSE IF in04 THEN dset=2;
ELSE IF in05 THEN dset=3; 
 
*Get the right weights for the combined 045 and 051 data; 
IF dset=1 THEN finlwt=(wgt045+FINLWT21)/2; 
   ELSE IF dset=2 THEN finlwt=wgt045/2;
   ELSE IF dset=3 THEN finlwt=FINLWT21/2;

DROP FINLWT21; 
RUN;

*************** Stack DATA  *******************************************;

DATA alldat.famstep01_10;
MERGE
famly011 famly012 famly013 famly014 
famly021 famly022 famly023 famly024
famly031 famly032 famly033 famly034
famly041 famly042 famly043 famly044
famly051 famly052 famly053 famly054
famly061 famly062 famly063 famly064
famly071 famly072 famly073 famly074
famly081 famly082 famly083 famly084 
famly091 famly092 famly093 famly094 
famly101 famly102 famly103 famly104 famly105
;
BY newid;

RUN;

PROC DATASETS LIBRARY=work;
DELETE 
famly011 famly012 famly013 famly014
famly021 famly022 famly023 famly024
famly031 famly032 famly033 famly034
famly041 famly042 famly043 famly044
famly051 famly052 famly053 famly054
famly061 famly062 famly063 famly064
famly071 famly072 famly073 famly074 
famly081 famly082 famly083 famly084 
famly091 famly092 famly093 famly094 
famly101 famly102 famly103 famly104 famly105
;

RUN;

PROC MEANS; 
RUN; 
 
PROC SORT; 
BY qyear;
PROC MEANS; 
BY qyear; 
RUN;

*%gzipsq(work,famstep01_10,~/jim/data);
